// config: norepeat

#include "GetObject.js"
#include "GetLine.js"

function DoRailRevolve()
{
	var objectpicker = moi.ui.createObjectPicker();
	objectpicker.allowCurves();
	
	if ( !GetObject( objectpicker ) )
		return;
		
	var profile = objectpicker.objects.item(0);
	
	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'ProfileSelectionPrompt' );
	moi.ui.showUI( 'RailSelectionPrompt' );
	moi.ui.endUIUpdate();

	if ( !GetObject( objectpicker ) )
		return;
		
	var rail = objectpicker.objects.item(0);
	
	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'RailSelectionPrompt' );
	moi.ui.showUI( 'FirstLinePrompt' );
	moi.ui.endUIUpdate();
	
	var points = new Array();

	if ( !GetLine( points ) )
		return;
	
	var factory = moi.command.createFactory( 'railrevolve' );
	factory.setInput( 0, profile );
	factory.setInput( 1, rail );
	factory.setInput( 2, points[0] );
	factory.setInput( 3, points[1] );
	factory.setInput( 4, moi.ui.commandUI.capends.value );

	factory.update();
	factory.commit();
}

DoRailRevolve();
